/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.widgets;

import com.quantumdata.widgets.QDBasicMenuItemUI;
import com.quantumdata.widgets.QDStdUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.border.Border;

public class QDCheckBoxMenuItem
extends JCheckBoxMenuItem {
    private static final long serialVersionUID = 1L;

    public QDCheckBoxMenuItem() {
        this.initLook();
    }

    public QDCheckBoxMenuItem(Icon icon) {
        super(icon);
        this.initLook();
    }

    public QDCheckBoxMenuItem(String string) {
        super(string);
        this.initLook();
    }

    public QDCheckBoxMenuItem(Action action) {
        super(action);
        this.initLook();
    }

    public QDCheckBoxMenuItem(String string, Icon icon) {
        super(string, icon);
        this.initLook();
    }

    public QDCheckBoxMenuItem(String string, boolean bl) {
        super(string, bl);
        this.initLook();
    }

    public QDCheckBoxMenuItem(String string, Icon icon, boolean bl) {
        super(string, icon, bl);
        this.initLook();
    }

    private void initLook() {
        QDStdUI.loadCheckIcons();
        this.setBackground(QDStdUI.getActionBackground());
        if (QDStdUI.g_menuStyle == 0) {
            this.setForeground(Color.black);
        }
        if (QDStdUI.g_menuStyle == 1) {
            this.setForeground(QDStdUI.getActionForeground());
        }
        Font font = QDStdUI.getActionFont();
        this.setFont(new Font(font.getName(), font.getStyle() | 2, font.getSize()));
        this.setBorder(this.createItemBorder());
        this.setUI(new QDBasicMenuItemUI());
        this.setOpaque(false);
        this.setIcon(QDStdUI.m_uncheckedIcon);
        this.setSelectedIcon(QDStdUI.m_checkedIcon);
        this.setDisabledIcon(QDStdUI.m_disabledIcon);
        this.setDisabledSelectedIcon(QDStdUI.m_disabledCheckedIcon);
        this.setRolloverEnabled(true);
        this.setRolloverIcon(QDStdUI.m_uncheckedROIcon);
        this.setRolloverSelectedIcon(QDStdUI.m_checkedROIcon);
    }

    private Border createItemBorder() {
        Border border = BorderFactory.createRaisedBevelBorder();
        int n = QDStdUI.getActionInset();
        Border border2 = BorderFactory.createEmptyBorder(n, n, n, n);
        return BorderFactory.createCompoundBorder(border, border2);
    }

    public void paint(Graphics graphics) {
        if (QDStdUI.g_menuStyle == 0) {
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, QDStdUI.getButtonLight(), 0.0f, this.getHeight(), QDStdUI.getButtonDark());
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setPaint(paint);
            if (this.isEnabled()) {
                this.setForeground(Color.black);
            } else {
                this.setForeground(Color.lightGray);
            }
        }
        if (QDStdUI.g_menuStyle == 1) {
            if (this.isEnabled()) {
                this.setForeground(QDStdUI.getActionForeground());
            } else {
                this.setForeground(Color.lightGray);
            }
        }
        super.paint(graphics);
    }
}

